/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.cauldrons;

import dev.xkmc.fruitsdelight.content.cauldrons.FruitCauldronBlock;
import dev.xkmc.fruitsdelight.content.cauldrons.JellyCauldronBlock;
import dev.xkmc.fruitsdelight.init.food.FDCauldrons;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import org.jetbrains.annotations.Nullable;

public class CauldronRenderHandler {
    public static int getBlockColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int layer) {
        Block block = state.m_60734_();
        if (block instanceof JellyCauldronBlock) {
            JellyCauldronBlock block2 = (JellyCauldronBlock)block;
            return block2.type.color;
        }
        int lemon = CauldronRenderHandler.merge(-1, FruitType.LEMON.color, 0.3f);
        if (state.m_60713_((Block)FDCauldrons.LEMON.get())) {
            return lemon;
        }
        Block block3 = state.m_60734_();
        if (block3 instanceof FruitCauldronBlock) {
            FruitCauldronBlock block4 = (FruitCauldronBlock)block3;
            int lv = (Integer)state.m_61143_((Property)FruitCauldronBlock.LEVEL);
            return CauldronRenderHandler.merge(lemon, block4.type.color, (float)lv / 12.0f);
        }
        return level != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos) : 4159204;
    }

    private static int merge(int x, int y, float f) {
        int xr = x >> 16 & 0xFF;
        int xb = x >> 8 & 0xFF;
        int xg = x & 0xFF;
        int yr = y >> 16 & 0xFF;
        int yb = y >> 8 & 0xFF;
        int yg = y & 0xFF;
        int zr = Math.round((float)xr * (1.0f - f) + (float)yr * f);
        int zb = Math.round((float)xb * (1.0f - f) + (float)yb * f);
        int zg = Math.round((float)xg * (1.0f - f) + (float)yg * f);
        return 0xFF000000 | zr << 16 | zb << 8 | zg;
    }

    public static int getItemColor(ItemStack stack, int i) {
        BlockState blockState;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            blockState = bi.m_40614_().m_49966_();
        } else {
            blockState = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
        }
        BlockState block = blockState;
        return CauldronRenderHandler.getBlockColor(block, null, null, i);
    }

    public static <T extends ModelBuilder<T>> ModelBuilder<T> gui(T builder) {
        return builder.guiLight(BlockModel.GuiLight.SIDE).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).scale(0.625f).end().end();
    }

    public static BlockModelBuilder guiAndTexture(BlockModelBuilder builder) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)CauldronRenderHandler.gui(builder).texture("bottom", "minecraft:block/cauldron_bottom")).texture("inside", "minecraft:block/cauldron_inner")).texture("particle", "minecraft:block/cauldron_side")).texture("side", "minecraft:block/cauldron_side")).texture("top", "minecraft:block/cauldron_top");
    }
}

